package cn.gtmap.hlw.core.util.wxjj;

import cn.hutool.core.codec.Base64Decoder;
import cn.hutool.core.codec.Base64Encoder;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;

/**
 * 3DES加密解密
 *
 * @author Marvin
 * @create: 2023/09/20 17:07
 */
public class DESedeEncryptor {

    /**
     * 3DES 解密
     *
     * @param in     解密原文字节数组
     * @param keyStr 密钥
     * @return
     * @throws Exception
     */
    public static String decrypt(byte[] in, String keyStr) throws Exception {
        byte[] dec_data = null;
        SecretKeyFactory skf = SecretKeyFactory.getInstance("DESede");

        SecretKey secretKey = skf.generateSecret(new DESedeKeySpec(Base64Decoder.decode(keyStr)));
        // 解密模式
        Cipher cipher = Cipher.getInstance("DESede");
        cipher.init(Cipher.DECRYPT_MODE, secretKey);
        dec_data = cipher.doFinal(in);
        return Base64Encoder.encode(dec_data);
    }

    /**
     * 3DES 加密
     *
     * @param in     要加密的原文内容
     * @param keyStr 密钥
     * @return
     * @throws Exception
     */
    public static byte[] encrypt(byte[] in, String keyStr) throws Exception {
        byte[] enc_data = null;
        SecretKeyFactory skf = SecretKeyFactory.getInstance("DESede");
        SecretKey secretKey = skf.generateSecret(new DESedeKeySpec(Base64Decoder.decode(keyStr)));
        // 加密模式
        Cipher cipher = Cipher.getInstance("DESede");
        cipher.init(Cipher.ENCRYPT_MODE, secretKey);
        enc_data = cipher.doFinal(in);

        return enc_data;
    }
}
