package cn.gtmap.hlw.core.dao.dict;


import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.dto.dict.an.ZdAnListParamsDTO;
import cn.gtmap.hlw.core.model.GxYyZdAn;

import java.util.List;

/**
 * 页面按钮字典表(GxYyZdAn)表数据库访问层
 *
 * @author makejava
 * @since 2023-11-16 09:07:34
 */
public interface GxYyZdAnDao {


    /**
     * 按钮下拉框
     *
     * @param paramsDTO
     * @return
     */
    List<GxYyZdAn> list(ZdAnListParamsDTO paramsDTO);

    /**
     * 根据id查询
     *
     * @param anIdList
     * @return:List<GxYyZdAnPO>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYyZdAn> listByAnIds(List<String> anIdList);

    /**
     * 删除
     *
     * @param anid
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void delete(String anid);

    /**
     * 详情
     *
     * @param anid
     * @return GxYyZdAnPO
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    GxYyZdAn get(String anid);

    /**
     * 新增修改
     *
     * @param gxYyZdAnPO
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void saveOrUpdateA(GxYyZdAn gxYyZdAnPO);

    /**
     * 分页查询
     *
     * @param paramsDTO
     * @return
     */
    PageInfo<GxYyZdAn> queryPage(ZdAnListParamsDTO paramsDTO);
    /**
     * 批量保存或更新
     *
     * @param zdAnPoList
     * @return
     */
    void saveOrUpdateBatch(List<GxYyZdAn> zdAnPoList);
}

