package cn.gtmap.hlw.core.dao.dict;

import cn.gtmap.hlw.core.dto.dict.fj.ZdFjQueryParamsDTO;
import cn.gtmap.hlw.core.model.GxYyZdFj;
import com.baomidou.mybatisplus.core.metadata.IPage;

import java.util.List;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/12/26
 * @description
 */
public interface GxYyZdFjDao {
    /**
     * 根据sqlx查询
     *
     * @param sqlx
     * @return:List<GxYyZdFjPO>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYyZdFj> listBySqlx(String sqlx);

    /**
     * 分页查询
     *
     * @param queryDTO
     * @return:IPage<GxYyZdFjPO>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    IPage<GxYyZdFj> page(ZdFjQueryParamsDTO queryDTO);

    /**
     * 批量更新保存
     *
     * @param zdFjPOList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void batchSaveOrUpdate(List<GxYyZdFj> zdFjPOList);

    /**
     * 更新保存
     *
     * @param zdFjPo
     * @return:void
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     */
    void saveOrUpdate(GxYyZdFj zdFjPo);

    /**
     * 根据id查询
     *
     * @param id
     * @return:GxYyZdFjPO
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    GxYyZdFj get(String id);

    /**
     * 根据id删除
     *
     * @param id
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void delete(String id);

    /**
     * 根据fjlx集合和sqlx查询
     *
     * @param list
     * @param sqlx
     * @return:List<GxYyZdFjPO>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYyZdFj> listByFjlxdmListAndSqlx(List<String> list, String sqlx);

    /**
     * 根据sqlx集合查询
     *
     * @param sqlxList
     * @return:List<GxYyZdFjPO>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYyZdFj> listBySqlxList(List<String> sqlxList);

    /**
     * 批量插入
     *
     * @param zdFjPoList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void insertBatchSomeColumn(List<GxYyZdFj> zdFjPoList);

    /**
     * 根据附件业务类型删除
     *
     * @param fjYwList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void deleteByFjYwList(List<String> fjYwList);

    /**
     * 根据sqlx删除
     *
     * @param sqlx
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void deleteBySqlx(String sqlx);


}
