package cn.gtmap.hlw.core.dto.sqxx.save;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/6/7 22:16
 * @description 资金监管
 */
@Data
public class ZjjgDTO implements Serializable {
    /**申请ID*/
    private String sqid;

    /**受理编号*/
    private String slbh;

    /**监管银行代码（JGXH字典表）*/
    private String jgyhdm;

    /** 义务人（卖方）姓名*/
    private String ywrxm;

    /** 义务人（卖方）银行账户*/
    private String ywryhzh;

    /** 权利人（买方）姓名*/
    private String qlrxm;

    /** 权利人（买方）银行账户*/
    private String qlryhzh;

    /** 监管金额（元)*/
    private String jgje;

    /** 是否监管定金（0:不监管 1:监管)*/
    private String sfjgdj;

    /** 利息归属（0:卖方 1:买方）*/
    private String lxgs;

    /**创建时间*/
    private Date createTime;

    /**
     * 修改时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    /**
     * 创建人员(gx_yy_user.USER_GUID)
     */
    private String createUser;

    /**
     * 修改人员(gx_yy_user.USER_GUID)
     */
    private String updateUser;

    /**
     * 资金监管收款账户户名
     */
    private String skzhmc;

    /**
     * 资金监管收款账户收款账号
     */
    private String skzhzh;
}
