package cn.gtmap.hlw.core.util.mdc;

import cn.gtmap.hlw.core.constant.Constants;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.MDC;

import java.util.UUID;

/**
 * @Description
 * @Author admin
 * @Date 2022/12/23 8:52
 * @Version
 **/
public class MdcUtil {

    /**
     * 获取traceId
     *
     * @return
     */
    public static String getTraceId() {
        return UUID.randomUUID().toString().replace("-", "").toUpperCase();
    }

    /**
     * @author
     * @date 2022/12/23 8:52
     * @descreption 链路追踪ID不存在时生成TRACE_ID
     */
    public static void setTraceIdIfAbsent(String traceId) {
        if (StringUtils.isBlank(traceId)) {
            traceId = getTraceId();
        }
        MDC.put(Constants.TRACE_ID, traceId);
    }

    /**
     * @author
     * @date 2022/12/23 8:52
     * @descreption 链路追踪ID清除
     */
    public static void removeTraceId() {
        MDC.remove(Constants.TRACE_ID);
        MDC.remove(Constants.STR_USERGUID);
        MDC.remove(Constants.STR_ROLEID);
    }

    public static void removeToken() {
        MDC.remove(Constants.TOKEN);
    }
}

