package cn.gtmap.hlw.core.util.encryption.sm4;

import cn.gtmap.hlw.core.util.string.StringUtil;
/**
 * @author <a href="mailto:jinfei@gtmap.cn">jinfei</a>
 * @Version 1.0，2023/03/27
 * @description SM4加密 SM4/EBC/PKCS5Padding
 */
public class SM4EcbPkcs5Util extends CipherUtil {

    /**
     * 算法名称
     */
    private static final String ALGORITHM_NAME = "SM4";

    /**
     * 加密/解密算法-工作模式-填充模式
     */
    private static final String CIPHER_ALGORITHM = "SM4/ECB/PKCS5Padding";


    /**
     * @description SM4解密 解密Base64字符串
     * @author <a href="mailto:xusong@gtmap.cn">xusong</a>
     * @date 2024-12-18 18:48
     * @param base64String Base64加密数据
     * @param key 加密秘钥 16个字符串（128bit）
     * @return String UTF-8编码
     */
    public static String decryptFromBase64String(String base64String, String key) {
        byte[] msgBytes = StringUtil.decodeBase64StrToByte(base64String);
        byte[] keyBytes = StringUtil.strToByteUtf8(key);
        return StringUtil.byteToStrUtf8(decrypt(msgBytes, keyBytes, null, ALGORITHM_NAME, CIPHER_ALGORITHM));
    }


}
