package cn.gtmap.hlw.core.model;

import cn.gtmap.hlw.core.annotation.ZdTypeConfig;
import cn.gtmap.hlw.core.constant.dict.ZdTypeConstant;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;


/**
 * 历史--申请信息_物流信息(GxYySqxxWlxx)表实体类BO
 *
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @since 2023-08-09 17:28:50
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class HgxYySqxxWlxx implements Serializable {

    private static final long serialVersionUID = 5869267116902315380L;
    /**
     * 物流ID
     */
    private String wlid;

    /**
     * 受理编号
     */
    private String slbh;

    /**
     * 领证方式代码
     */
    private String lzfsdm;

    /**
     * 领证方式名称
     */
    @ZdTypeConfig(field = "lzfsdm", tableName = ZdTypeConstant.ZD_TYPE_LZFS, dmToMc = true)
    private String lzfsmc;

    /**
     * 收件人联系电话
     */
    private String sjrlxdh;

    /**
     * 收件人名称
     */
    private String sjrmc;

    /**
     * 收件人证件号
     */
    private String sjrzjh;

    /**
     * 收件人证件种类
     */
    private String sjrzjzl;

    /**
     * 收件人所在市
     */
    private String sjrszshi;

    /**
     * 收件人所在省
     */
    private String sjrszsheng;

    /**
     * 收件人所在县
     */
    private String sjrszx;

    /**
     * 收件人详细地址
     */
    private String sjrxxdz;

    /**
     * /领证人名称
     */
    private String lzrmc;

    /**
     * 领证人证件种类
     */
    private String lzrzjzl;

    /**
     * 领证人证件种类名称
     */
    @ZdTypeConfig(field = "lzrzjzl", tableName = ZdTypeConstant.ZD_TYPE_ZJLX, dmToMc = true)
    private String lzrzjzlmc;

    /**
     * 领证人证件号
     */
    private String lzrzjh;

    private String ddh;

    /**
     * 领证人联系电话
     */
    private String lzrlxdh;

    /**
     * 领证详细地址
     */
    private String lzxxdz;

    /**
     * 收件人电子邮箱
     */
    private String sjrEmail;

    private String sqid;

    /**
     * 领证时间代码（gx_yy_zd_type.LZSJ）
     */
    private String lzsjdm;

    /**
     * 是否委托 1是0否
     */
    private String sfwt;

    /**
     * 收件人邮编
     */
    private String sjryb;

    /**
     * 邮寄证书数量
     */
    private String yjzssl;

    /**
     * 邮寄收件人备用手机号
     */
    private String yjsjrbysjh;

    /**
     * 与委托人关系(代码，YWTRGX字典项)
     */
    private String ywtrgx;


}

