package cn.gtmap.hlw.core.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;


/**
 * 流程打印配置(GxYyLcdyPz)表实体类BO
 *
 * @author makejava
 * @since 2023-07-10 15:19:36
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GxYyLcdyPz implements Serializable {
    private static final long serialVersionUID = -2659135095711553435L;
    /**主键 */
    private String pzid;

    /**打印文件类型(枚举值：spb,sqs,sjd)*/
    private String dywjlx;

    /**文件格式（枚举值：pdf,word,png)*/
    private String wjgs;

    /**文件名称，与gx_yy_zd_fj.mc对应*/
    private String wjmc;

    /**特殊申请类型需要单独配置，通用的配置为0000000*/
    private String sqlx;

    /**行政区域代码*/
    private String xzqydm;

    /**模板地址，hlw-currency环境下*/
    private String mbdz;

    /**配置关键字*/
    private String pzgjz;

    /**附件类型代码*/
    private String fjlx;

    /**印章图片地址*/
    private String yztpdz;

    /**签章类型*/
    private Integer qzlx;

    /**签名位置*/
    private Integer qmwz;

    /**默认x坐标*/
    private String x;

    /**默认y坐标*/
    private String y;

    /**私有x坐标*/
    private String syzbX;

    /**私有y坐标*/
    private String syzbY;

    /**签名展示收缩比例*/
    private String qmzsssbl;

    /**qlrlx(1权利人，2义务人)*/
    private String qlrlx;

    /**是否添加签署时间，0否1是*/
    private String sftjqssj;

    /**签署区宽（默认印章宽度）*/
    private String qsqk;

    /**
     * 签章页码
     */
    private String qzym;

    /**
     * 签署顺序
     */
    private String qssx;

    /**
     * 登记原因
     */
    private String djyy;

    /**
     * 是否适用于签字板，1：是  0：否
     */
    private String sfsyqzb;

    /**
     * 顺序号
     */
    private Integer sxh;
}

