package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYySqxxTdxx;

import java.util.List;

/**
 * 在线申请--土地信息(GxYySqxxTdxx)表数据库访问层
 *
 * @author makejava
 * @since 2023-05-31 14:14:50
 */
public interface GxYySqxxTdxxRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param sqid 主键
     * @return 实例对象
     */
    GxYySqxxTdxx get(String sqid);

    /**
     * 通过slbh查询集合数据
     *
     * @param slbh 主键
     * @return 实例对象
     */
    List<GxYySqxxTdxx> getBySlbh(String slbh);

    /**
     * 新增数据
     *
     * @param gxYySqxxTdxx 实例对象
     * @return 影响行数
     */
    void save(GxYySqxxTdxx gxYySqxxTdxx);

    /**
     * 修改数据
     *
     * @param gxYySqxxTdxx 实例对象
     * @return 影响行数
     */
    void update(GxYySqxxTdxx gxYySqxxTdxx);

    /**
     * 修改数据
     *
     * @param gxYySqxxTdxx 实例对象
     * @return
     */
    void saveOrUpdate(GxYySqxxTdxx gxYySqxxTdxx);

    /**
     * 通过sqidList查询单条数据
     *
     * @param sqidList 主键
     * @return 实例对象
     */
    List<GxYySqxxTdxx> list(List<String> sqidList);

    /**
     * 通过sqidList删除数据
     *
     * @param sqidList 主键
     * @return 实例对象
     */
    int deleteBatchIds(List<String> sqidList);
    /**
     * 批量更新或保存
     * @param tdxxList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    void saveOrUpdateBatch(List<GxYySqxxTdxx> tdxxList);
    /**
     * 根据sqid删除
     * @param sqid
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    void deleteById(String sqid);

    int delete(String slbh);

    /**
     * 批量插入
     * @param tdxxList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void insertBatch(List<GxYySqxxTdxx> tdxxList);
}

