package cn.gtmap.hlw.core.enums.spxx;

import cn.gtmap.hlw.core.enums.BffsEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/11/8
 * @description 审批状态枚举
 */
@Getter
@AllArgsConstructor
public enum SpztEnum {
    /**
     * 未审核
     */
    SPZT_WSH("1", "未审核"),
    /**
     * 审核通过
     */
    SPZT_SHTG("2", "审核通过"),
    /**
     * 审核未通过
     */
    SPZT_SHWTG("3", "审核未通过"),

    /**
     * 已审核
     */
    SPZT_YSH("9", "已审核"),
    /**
     * 登簿
     */
    SPZT_DB("14", "登簿"),
    /**
     * 核税
     */
    SPZT_HS("40", "核税"),
    /**
     * 完税
     */
    SPZT_WS("90", "完税"),

    /**
     * 受理
     */
    SPZT_XSSH_SL("4", "收件受理"),
    /**
     * 复审
     */
    SPZT_XSSH_FS("5", "复审"),
    /**
     * 核定
     */
    SPZT_XSSH_HD("6", "核定登簿"),
    /**
     * 缮证
     */
    SPZT_XSSH_SZ("7", "缮证");

    private String code;

    private String msg;

    public static String getMsg(String code) {
        for (SpztEnum xq : SpztEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getMsg();
            }
        }
        return null;
    }
}
