package cn.gtmap.hlw.core.util.stream;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2024/4/25
 * @description
 */
public class StreamUtils {
    /**
     * 按某个指定字段去重
     *
     * @param keyExtractor
     * @return:Predicate<T>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        Map<Object, Boolean> seen = new ConcurrentHashMap<>();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }
}
