package cn.gtmap.hlw.core.dto.news;

import cn.gtmap.hlw.core.base.BasePage;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/7/3 10:27
 * @description CustomNewsResultDTO
 */
@Data
public class CustomNewsQueryParamsDTO  extends BasePage {
    /**所属类型（0:所有，1：微信，2：web）*/
    private String type;
    /**新闻类型关联字典表 对应 gx_yy_zd_type.dm and zd_type= NEWS_TYPE*/
    private String newsType;
    /**主键 */
    private String id;
    /**标题 */
    private String title;
    /**开始时间*/
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startDate;
    /**结束时间*/
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endDate;
    /**来源*/
    private String origin;
    /**状态*/
    private String status;
    /**
     * 专题服务id
     */
    private String ztfwid;
    /**
     * 申请类型
     */
    private String sqlx;
}
