package cn.gtmap.hlw.core.dto.login;

import lombok.Data;

/**
 * 登录信息
 *
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/6/8 15:59
 * @description LoginResultDTO
 */
@Data
public class LoginResultDTO {

    /* 用户信息 */

    /**
     * 用户id
     */
    private String userGuid;
    /**
     * 用户名
     */
    private String userName;
    /**
     * 用户真实名称
     */
    private String realName;
    /**
     * 用户证件号
     */
    private String userZjid;
    /**
     * 证件类型
     */
    private String zjType;
    /**
     * 用户联系电话
     */
    private String lxDh;
    /**
     * 是否验证
     */
    private String sfyz;
    /**
     * 用户角色
     */
    private String roleId;
    /**
     * 角色名称
     */
    private String roleName;
    /**
     * 登陆人区域代码传gx_yy_user.qydm
     */
    private String qydm;
    /**
     * 用户脱敏信息
     */
    /**
     * 用户真实名称 脱敏
     */
    private String realNameTm;
    /**
     * 用户证件号 脱敏
     */
    private String userZjidTm;
    /**
     * 用户联系电话 脱敏
     */
    private String lxDhTm;

    /**
     * 从业资质证号,取gx_yy_user表里zgzhbh资格证书编号 字段
     */
    private String cyzzzh;

    /* 企业信息*/
    /**
     * 企业ID
     */
    private String orgId;
    /**
     * 企业名称
     */
    private String orgName;
    /**
     * 企业证件类型
     */
    private String orgZjlx;
    /**
     * 统一社会信用代码
     */
    private String orgTyxydm;
    /**
     * 法定代表人
     */
    private String orgFddbr;
    /**
     * 法定代表人证件类型
     */
    private String orgFddbrzjlx;
    /**
     * 法定代表人电话
     */
    private String orgFddbrdh;
    /**
     * 法定代表人证件号
     */
    private String orgFddbrzjh;
    /**
     * 企业行政区划代码，传gx_yy_org.qydm
     */
    private String orgQydm;
    /**
     * 企业联系电话
     */
    private String orgLxdh;


    /* 企业脱敏信息*/
    /**
     * 企业名称 脱敏
     */
    private String orgNameTm;
    /**
     * 统一社会信用代码 脱敏
     */
    private String orgTyxydmTm;
    /**
     * 法定代表人 脱敏
     */
    private String orgFddbrTm;
    /**
     * 法定代表人电话
     */
    private String orgFddbrdhTm;
    /**
     * 法定代表人证件号
     */
    private String orgFddbrzjhTm;

    /**跳转用户中心*/
    private String yhzxdz;
    /**0,未过期，1即将过期*/
    private String expire;
    /**token*/
    private String token;

    private String userPwd;

    /**是否有签章权限（1:有，:0或空:无）*/
    private String sfyqzqx;
    /**
     * 是否月结
     */
    private String sfyj;
    /**
     * 组织所在市
     */
    private String orgSzshi;

    /**
     * 组织所在省
     */
    private String orgSzsheng;

    /**
     * 组织所在县
     */
    private String orgSzxian;
    /**柜面机窗口电脑IP*/
    private String sysIp;
    /**
     * 内外网标识（1：内网， 2：外网 ）
     */
    private String nwwbs;

    /**政务网用户ID*/
    private String onemapId;

}
