package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.dto.menu.index.IndexConfigQueryDTO;
import cn.gtmap.hlw.core.dto.menu.menu.MenuQueryParamsDTO;
import cn.gtmap.hlw.core.model.GxYyFunctionMenu;
import cn.gtmap.hlw.core.model.GxYyMenu;

import java.util.List;

/**
 * (GxYyMenu)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-01 14:34:59
 */
public interface GxYyMenuRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    GxYyMenu get(String id);

    /**
     * 新增数据
     *
     * @param gxYyMenu 实例对象
     * @return 影响行数
     */
    void save(GxYyMenu gxYyMenu);

    /**
     * 修改数据
     *
     * @param gxYyMenu 实例对象
     * @return 影响行数
     */
    void update(GxYyMenu gxYyMenu);

    /**
     * 修改数据
     *
     * @param queryDTO          查询条件对象
     * @param gxYyFunctionMenus 功能菜单对象集合
     * @return 影响行数
     */

    List<GxYyMenu> getMenuByQueryParams(IndexConfigQueryDTO queryDTO, List<GxYyFunctionMenu> gxYyFunctionMenus);

    /**
     * 根据菜单ID查询GxYyMenu
     *
     * @param functionMenuId 菜单ID
     * @return GxYyMenu
     */
    GxYyMenu getMenuByFunctionMenuId(String functionMenuId);

    /**
     * 获取数据
     *
     * @param functionMenuList 功能菜单集合
     * @param clientype        客户端类型
     * @param areaType         区域类型
     * @return 影响行数
     */
    List<GxYyMenu> getMenuListByFunctionMenu(List<String> functionMenuList, String clientype, String areaType);

    /**
     * 获取数据
     *
     * @param functionMenuIds 功能菜单id集合
     * @param clientype       客户端类型
     * @param areaType        区域类型
     * @param roleId          角色id
     * @return 影响行数
     */
    List<GxYyMenu> getMenuListByFunctionMenuIds(List<String> functionMenuIds, String clientype, String areaType, String roleId);

    /**
     * 根据 sqlx+CLIENT_TYPE去查询
     *
     * @param sqlxdm
     * @param clientType
     * @return
     */
    GxYyMenu getMenuBySqlxAndClientType(String sqlxdm, String clientType);

    /**
     * 根据角色查询菜单
     *
     * @param roleId
     * @return
     */
    List<GxYyMenu> getMenuByRoleId(String roleId);

    /**
     * 根据MenuQueryParamsDTO查询菜单
     *
     * @param queryDTO
     * @return
     */
    List<GxYyMenu> getMenuByMenuQueryParams(MenuQueryParamsDTO queryDTO);

    /**
     * 分页查询
     *
     * @param paramsDTO 入参
     * @return
     */

    PageInfo<GxYyMenu> queryPage(MenuQueryParamsDTO paramsDTO);

    /**
     * 根据id删除
     *
     * @param paramsDTO
     */
    void deleteById(MenuQueryParamsDTO paramsDTO);

    /**
     * 保存更新
     *
     * @param gxYyMenu
     */
    void saveOrUpdate(GxYyMenu gxYyMenu);

    /**
     * 根据菜单id查询
     *
     * @param menuIds
     * @return:List<GxYyMenu>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYyMenu> listByFunctionMenuIdsAndRoleId(List<String> menuIds, String roleId);

    /**
     * 根据菜单id查询
     *
     * @param functionMenuIdList
     * @return:List<GxYyMenu>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYyMenu> treeByFunctionMenuIdsAndRoleIdAndUserId(List<String> functionMenuIdList, String roleId, String userId);
    /**
     * 根据sqlx查询
     * @param sqlxList
     * @return:java.util.List<cn.gtmap.hlw.core.model.GxYyMenu>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYyMenu> getBySqlxList(List<String> sqlxList);
}

