package cn.gtmap.hlw.core.enums.login;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 登录状态 ：10 00 00
 * * 前两位10：登录场景
 * * 中间两位00：表示角色 00代表所有角色通用
 * * 后两位00：表示场景状态码
 *
 * @author admin
 * @Date 2023/4/17 17:11
 * @Version V1.0
 */
@AllArgsConstructor
public enum LoginEnum {
    /**
     * 密码复杂度太低 状态码
     */
    LOGIN_PASSSWORD_FZDTD("1000", "密码复杂度太低，请修改密码后重新登录"),

    /**
     * 用户授权已过期
     */
    LOGIN_USER_SQGQ("1001", "您的授权已过期，请联系管理员重新授权后再登录"),

    /**
     * 登出成功 状态码
     */
    OUT_SUCCESS("1002", "登出成功"),

    /**
     * 非法登录 状态码
     */
    ILLEGAL_LOGIN("1003", "非法登录"),

    /**
     * 登录失败 状态码
     */
    LOGIN_ERROR("1004", "登录失败"),

    /**
     * 登录校验事件代码不能为空 状态码
     */
    LOGIN_LYSJDM_NOTNULL("1005", "登录校验事件代码不能为空"),

    /**
     * 未获取到登录事件 状态码
     */
    LOGIN_QUERY_LYSJ_NULL("1006", "未获取到登录事件"),

    /**
     * 验证码不正确
     **/
    YZM_FAIL("1008", "验证码不正确"),

    /**
     * 密码不正确
     */
    PASSWORD_FAIL("1009", "用户名或密码不正确"),

    /**
     * "密码输入错误次数过 状态码
     */
    LOGIN_PASSSWORD_CUCSTD("1010", "密码输入错误次数过多，已被锁定，请稍后再试"),

    /**
     * 账户审核未通过
     */
    SHZT_FAIL("1011", "账户审核未通过"),

    /**
     * 不在有效期内
     */
    YXQ_FAIL("1012", "不在有效期内"),

    /**
     * CA登录不正确
     */
    CALOGIN_FAIL("1013", "CA登录不正确"),

    /**
     * 指纹登录不正确
     */
    ZWLOGIN_FAIL("1014", "指纹登录不正确"),

    /**
     * 未授权
     */
    NO_ROLE("1015", "登录用户未被授予角色，无权登录"),

    /**
     * 被禁用
     */
    JY_FAIL("1016", "被禁用"),

    /**
     * 未获取到user信息
     */
    NO_USER("1017", "未获取到user信息"),

    /**
     * 没有登陆权限
     */
    NO_LOGIN("1018", "没有登陆权限"),

    /**
     * 没有登陆权限
     */
    YZM_NULL("1019", "验证码为空"),
    /**
     * 密码即将到期
     */
    WILL_EXPIRE("1020", "密码即将到期，请修改密码"),
    /**
     * 密码已过期
     */
    HAS_EXPIREED("1021", "密码已过期"),

    /**
     * 其他 状态码
     */
    LOGIN_ERROT_ZDY("1999", "");


    @Getter
    private String code;

    @Getter
    private String msg;

    /**
     * 根据code获取msg
     */
    public static String getMsg(String code) {
        for (LoginEnum xq : LoginEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getMsg();
            }
        }
        return null;
    }

}
