package cn.gtmap.hlw.core.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2024/2/23
 * @description 数据可见范围
 */
@Getter
@AllArgsConstructor
public enum DataScopeEnum {
    /**
     * 本人
     */
    BR("1", "本人"),
    /**
     * 本部门
     */
    BBM("2", "本部门"),
    /**
     * 本部门及下属部门
     */
    BBMJXSBM("3", "本部门及下属部门"),
    /**
     * 全部
     */
    QB("4", "全部");

    private String code;

    private String msg;

}
