package cn.gtmap.hlw.core.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2024/2/22
 * @description
 */
@Getter
@AllArgsConstructor
public enum BffsEnum {
    /**
     * 备份方式 - 自动备份
     */
    BFFS_ZDBF("0", "自动备份"),
    /**
     * 备份方式-  手动备份
     */
    BFFS_SDBF("1", "手动备份");

    private String code;

    private String msg;

    public static String getMsg(String code) {
        for (BffsEnum xq : BffsEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getMsg();
            }
        }
        return null;
    }
}
