package cn.gtmap.hlw.core.dto.ztfw;

import cn.gtmap.hlw.core.node.INode;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2024/5/24
 * @description
 */
@Data
public class ZtfwDTO implements INode<ZtfwDTO> {
    /**
     * 子孙节点
     */
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<ZtfwDTO> children;

    /**
     * 主键ID
     */
    private String id;
    /**
     * 主题服务名称
     */
    private String ztfwmc;
    /**
     * 顺序号
     */
    private Integer sxh;

    /**
     * 父节点ID
     */
    private String parentId;

    @Override
    public List<ZtfwDTO> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<>();
        }
        return this.children;
    }
}
