/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.encryption;

import cn.gtmap.hlw.core.base.ApiEncryptBody;
import cn.gtmap.hlw.core.util.encryption.sm2.Sm2lib;
import cn.gtmap.hlw.core.util.encryption.sm4.Sm4Util;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiSecurityUtils {
    private static final Logger log = LoggerFactory.getLogger(ApiSecurityUtils.class);

    public static String decrypt(String sm4KeyBySm2, String decryptStr) {
        String sm4Key = Sm2lib.decode(sm4KeyBySm2);
        return Sm4Util.decryptEcb(sm4Key, decryptStr);
    }

    public static ApiEncryptBody encrypt(String encryptStr, String frontPublicKey) {
        String sm4Key = null;
        try {
            sm4Key = Sm4Util.generateKey();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String data = Sm4Util.encryptEcbByHutool(sm4Key, encryptStr);
        ApiEncryptBody apiEncryptRes = new ApiEncryptBody();
        apiEncryptRes.setParamid(Sm2lib.encode(sm4Key, frontPublicKey));
        apiEncryptRes.setData(data);
        apiEncryptRes.setFrontKey(frontPublicKey);
        return apiEncryptRes;
    }

    public static void main(String[] args) throws Exception {
        String pubKey = "c2f1831616943efe504bde6b45d59eea953f04d31ecebd4c59dffd6733c7a066c7a9c14cb2c54564187891f72753fea7f56d07b19d52e9076263564def41b8e7";
        String dataEncrypt = "729bf942bc03c237b0ac6b24b9c640d825bdb34a2db4b9cc64b19376cfa2400e8a87ab0d190791d949c7a037d90929e2b7f38f1d8e2aa421442ee34376eeb4a002bf741274720ac4ff1c60fb0ac8a9341153fb06e8beb2fdd5b6b5407996a5ed5d1c7da1f622151b1551af224dacb7ac5f1925d8e6a04f8e8947ca70f5109ced02426af05d7d22d25f9e313b5cfe72d55200a3c7f2a481d02291ce13cddb142964f4939b56c3239c44a8ce6cd9c7d4dd1e4c48edbc56af2bcf6a560a4740e006";
        String paramid = "0479143026a99e3c9c806341b289628a1b40bb4eb88af50aa909706232c674f29f85ad6d9d93d3a52a5af3435f3c17a151cadf8064320686f9673178a0690d32228ba563e0720ce15af57b77f4bbeaa4fd05db793b4be254ca7f93bf21f720d96432ae97ded8e8e5415aec5429a45c4f22cb0c49bea176a7c858e30f1959ad4d1e8013a126e7ee1e433125cab3";
        String qdData = ApiSecurityUtils.decrypt(paramid, dataEncrypt);
        System.out.println(qdData);
        String sm4Key = "B13356B451572BFC3478AC20F0E3E163";
        String encryptStr = "{\"slbh\":\"W202503190079\",\"processId\":\"b912481754e64dfea519b07745f68dc7\",\"anid\":\"\"}";
        String data = Sm4Util.encryptEcbByHutool(sm4Key, encryptStr);
        String paramid2 = Sm2lib.encode(sm4Key);
        ApiEncryptBody body = new ApiEncryptBody();
        body.setData(data);
        body.setParamid(paramid2);
        body.setFrontKey(pubKey);
        System.out.println(JSON.toJSONString((Object)body));
    }
}

