package cn.gtmap.hlw.core.dao.jksx;

import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.dto.jkgl.jksx.JksxPageParamsDTO;
import cn.gtmap.hlw.core.model.GxYyJksx;

import java.util.List;

/**
 * 接口实现表(GxYyJksx)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-06 14:48:08
 */
public interface GxYyJksxDao {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    GxYyJksx get(String id);

    /**
     * 通过ID查询单条数据
     *
     * @param jkglid 接口管理id
     * @return 实例对象
     */
    GxYyJksx getByJkglid(String jkglid);


    /**
     * 根据接口管理id查询实现类
     *
     * @param jkglid
     * @return
     */
    GxYyJksx query(String jkglid);

    /**
     * 接口实现 分页查询
     *
     * @param paramsDTO
     * @return
     */

    PageInfo<GxYyJksx> queryPage(JksxPageParamsDTO paramsDTO);

    /**
     * 接口实现 删除
     *
     * @param id 主键
     * @return 删除的条数
     */
    int delete(String id);

    /**
     * 根据接口管理id删除数据
     *
     * @param jkglid 接口管理id
     * @return 删除的条数
     */
    int deleteByJkglid(String jkglid);

    /**
     * 根据接口管理id删除数据
     *
     * @param jkglIdList 接口管理id
     * @return 删除的条数
     */
    int deleteByJkglidList(List<String> jkglIdList);

    /**
     * 保存更新
     *
     * @param gxYyJksx
     */
    void saveOrUpdateJksx(GxYyJksx gxYyJksx);

    /**
     * 根据jkglid查询集合
     *
     * @param jkglIdList
     * @return GxYyJksxPO集合
     */
    List<GxYyJksx> getByJkglidList(List<String> jkglIdList);

    /**
     * 批量插入
     *
     * @param jksxPoList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void insertBatch(List<GxYyJksx> jksxPoList);

    List<GxYyJksx> getListByIds(List<String> jksxIdList);
}

