package cn.gtmap.hlw.core.dao.dsrw;

import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.dto.dsrw.DsrwDTO;
import cn.gtmap.hlw.core.dto.dsrw.DsrwPageQueryDTO;
import cn.gtmap.hlw.core.dto.dsrw.DsrwPageResultDTO;
import cn.gtmap.hlw.core.model.GxYyDsrw;

import java.util.List;

/**
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @version 2023/12/18 14:29
 * @description 定时任务
 */

public interface GxYyDsrwDao {

    /**
     * 分页查询
     *
     * @param paramsDTO
     * @return
     */
    PageInfo<DsrwPageResultDTO> queryPage(DsrwPageQueryDTO paramsDTO);

    /**
     * 查询
     *
     * @param jobId
     * @return
     */
    DsrwDTO getById(String jobId);

    /**
     * 更新
     *
     * @param dsrwDTO
     * @return
     */
    void updateById(DsrwDTO dsrwDTO);

    /**
     * 保存更新
     *
     * @param dsrwDTO
     * @return
     */
    void saveOrUpdate(DsrwDTO dsrwDTO);

    /**
     * 查询
     *
     * @return
     */
    List<GxYyDsrw> getAll();

    /**
     * 删除
     *
     * @param dsrwid
     * @return
     */
    int delete(String dsrwid);

}
