package cn.gtmap.hlw.core.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 单点登录接入表(GxYyDddl)表实体类BO
 *
 * @author makejava
 * @since 2023-12-04 16:01:53
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GxYyDddl implements Serializable {
    /**
     * 表id
     */
    private String id;

    /**
     * 终端类型(gx_yy_zpi_user.origin)
     */
    private String origin;

    /**
     * 登录方式（企业、登记机构、个人、管理员 登录入口）
     */
    private String dlfs;

    /**
     * 单点登陆系统名称
     */
    private String dddlxtmc;

    /**
     * 单点登录系统地址
     */
    private String dddlxtdz;

    /**
     * 顺序号（单点登录排列顺序）
     */
    private Integer sxh;

    /**
     * 单点登录图标
     */
    private String dddltb;

    /**
     * 创建时间
     */
    private Date cjsj;

    /**
     * 创建人（gx_yy_user.user_guid）
     */
    private String cjr;
    /**
     * appid
     */
    private String appid;
    /**
     * 接口实现类
     */
    private String jksxl;


}

