package cn.gtmap.hlw.core.enums.qlr;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/9/27
 * @description 云签状态
 */
@Getter
@AllArgsConstructor
public enum YqztEnum {
    /**创建状态**/
    CJZT_FAILURE(0, "签署失败"),
    CJZT_SUCCESS(1, "未签署"),
    CJZT_YQS(2, "已签署"),
    CJZT_QSZ(3, "签署中"),
    CJZT_JQ(4, "拒签");

    private Integer code;

    private String msg;

    public static String getMsg(Integer code) {
        for (YqztEnum xq : YqztEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getMsg();
            }
        }
        return null;
    }
    public static Integer getCode(Integer code) {
        for (YqztEnum xq : YqztEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getCode();
            }
        }
        return null;
    }
}
