package cn.gtmap.hlw.core.dao.dypz;


import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.dto.dypz.DysjPzPageParamsDTO;
import cn.gtmap.hlw.core.model.GxYyDysjPz;

import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
 * @version 1.0, 2024/5/30
 * @description 打印主表配置表 数据库访问层
 */
public interface GxYyDysjPzDao {
    /**
     * 通过ID查询单条数据
     *
     * @param dyid 主键
     * @return 实例对象
     */
    GxYyDysjPz get(String dyid);


    /**
     * 修改数据
     *
     * @param gxYyDysjPzPO 实例对象
     * @return 影响行数
     */
    int update(GxYyDysjPz gxYyDysjPzPO);

    /**
     * 获取全部数据
     *
     * @return GxYyDysjPzPO集合
     */
    List<GxYyDysjPz> getAll();

    /**
     * 通过ID删除单条数据
     *
     * @param dyid 主键
     * @return 实例对象
     */
    void delete(String dyid);

    PageInfo<GxYyDysjPz> queryPage(DysjPzPageParamsDTO paramsDTO);

    /**
     * @param
     * @return
     * @author <a href="mailto:chenjia@gtmap.cn">chenjia</a>
     * @description 执行sql
     */
    List<Map> executeConfigSql(String sql);

    void save(GxYyDysjPz gxYyDysjPz);
}
