package cn.gtmap.hlw.core.dto.sw.hs.zlf.ah;

import cn.gtmap.hlw.core.annotation.ZdDzConfig;
import cn.gtmap.hlw.core.constant.dict.ZdDzConstant;
import lombok.Data;

import java.util.List;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/8/30
 * @description
 */
@Data
public class QlrxxDTO {
    /**
     * 纳税人名称
     */
    private String nsrmc;
    /**
     * 纳税人类型
     */
    private String nsrlx;
    /**
     * 证件类型代码
     */
    @ZdDzConfig(field = "sfzjlxDm", tableName = ZdDzConstant.ZD_DZ_ZJLX, dmToDm = true)
    private String sfzjlxDm;
    /**
     * 证件类型名称
     */
    @ZdDzConfig(field = "sfzjlxMc", tableName = ZdDzConstant.ZD_DZ_ZJLX, dmToMc = true)
    private String sfzjlxMc;
    /**
     * 身份证件号码
     */
    private String sfzjhm;
    /**
     * 联系电话
     */
    private String lxdh;
    /**
     * 地址
     */
    private String dz;
    /**
     * 房屋套次
     */
    private String fwtc;
    /**
     * 纳税人自己申报套数
     */
    private String sbFwtc;
    /**
     * 国籍代码
     */
    private String gjDm;
    /**
     * 主产权人标志
     */
    private String zcqrbz;
    /**
     * 共有方式
     */
    private String gyfs;
    /**
     * 交易份额
     */
    private String jyfe;
    /**
     * 所占份额
     */
    private String szfe;
    /**
     * 拆迁是否是货币补偿标记
     */
    private String cqhbbcbj;
    /**
     * 拆迁安置补偿金额
     */
    private String cqazbcje;
    /**
     * 是否小规模纳税人
     */
    private String sfxgmnsr;
    /**
     * 房查地址
     */
    private List<String> fcdz;
}
