package cn.gtmap.hlw.core.util.wxjj;

import cn.hutool.core.codec.Base64Decoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.security.*;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;

/**
 * @author Marvin
 * @create: 2023/09/20 17:12
 */
public class HttpSignature {

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    // 数字签名对象
    private Signature signa = null;

    //签名算法
    private String sign_algorithm = "MD5WithRSA";

    public HttpSignature() {
        if (signa == null) {
            try {
                this.signa = Signature.getInstance(this.sign_algorithm);
            } catch (NoSuchAlgorithmException e) {
                this.logger.error("没有这个算法的签名对象：" + this.sign_algorithm, e);
            } catch (Exception e) {
                this.logger.error("创建加签名对象时出现异常!", e);
            }
        }
    }


    /**
     * 数字签名
     *
     * @param in  原文内容
     * @param key 服务端私钥
     * @return
     */
    public byte[] sign(byte[] in, String key) throws Exception {
        byte[] signdata = null;
        PrivateKey pri_key = getPrivateKey(key);
        try {
            // 初始化签名对象
            signa.initSign(pri_key);
            signa.update(in);
            // 执行签名方法，得到数据
            signdata = signa.sign();
        } catch (InvalidKeyException e) {
            this.logger.error("初始化签名对象出现异常，服务器证书私钥不正确!", e);
            throw new Exception("初始化签名对象出现异常，服务器证书私钥不正确!");
        } catch (SignatureException e) {
            this.logger.error("进行数字签名时出现异常!", e);
            throw new Exception("进行数字签名时出现异常!");
        } catch (Exception e) {
            throw new Exception("数字签名出现异常!");
        }
        return signdata;
    }

    /**
     * 获取私钥
     */
    private PrivateKey getPrivateKey(String pri_key) {
        PrivateKey privateKey = null;
        KeyFactory keyFactory;
        try {
            keyFactory = KeyFactory.getInstance("RSA");
            privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(Base64Decoder.decode(pri_key)));
        } catch (NoSuchAlgorithmException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (InvalidKeySpecException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }

        return privateKey;
    }

}
