package cn.gtmap.hlw.core.util.encryption.sm2;

import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Base64;

/**
 * @Description 加密工具工具类
 * @Author admin
 * @Date 2022/12/28 10:51
 * @ClassName Sm2lib
 * @Version V1.0
 **/
public class Sm2lib {

    private static Logger logger = LoggerFactory.getLogger(Sm2lib.class);

    /**
     * 公钥
     */
    private static final String PUBLIC_KEY = "0410ad277ad243570d37be0decff5a498ca9bbb8ed66ba80321383b272f55041b8f4219d808c035bead2353cae3d23b6550201f492b8d9feefe32920418f1cf039";
    private static final String PUBLIC_KEY_OLD = "049613BB58C32CBB679B63C6CE778E4C3A3C794D8C8C89DE255B1298053CB889796DC513663E71C59BE0DB1BF4279F8E500E89A5B51EA37367C3A5D624FDFD831C";;

    /**
     * 私钥
     */
    private static final String PRIVATE_KEY = "98c8b4a9c0b58e620e1645e817e632190da5c993c04b27b3a5b61b3673498ef1";
    private static final String PRIVATE_KEY_OLD = "CF63CDC4BDEF75F8DEF07EC4DE19A5E2B71525C0278A5EC7C8556290B3371535";

    private static final String GM_NAMED = "sm2p256v1";

    /**
     * 加密字段判断标识位
     */
    private static final String TAG = "04";


    /**
     * @Description 解密(默认私钥)
     * @Author admin
     * @Date 2023/5/15 9:13
     */
    public static String decode(String plaintext) {
        return decode(plaintext, PRIVATE_KEY);
    }

    /**
     * @Description 解密(老互联网系统私钥)
     * @Author admin
     * @Date 2023/5/15 9:13
     */
    public static String decodeOldSys(String plaintext) {
        return decode(plaintext, PRIVATE_KEY_OLD);
    }

    /**
     * @Description 解密
     * @Author admin
     * @Date 2023/5/15 9:13
     */
    public static String decode(String cipherData, String privateKey) {
        if (StringUtils.isBlank(cipherData)) {
            return cipherData;
        }
        if (!StringUtils.startsWithIgnoreCase(cipherData, TAG)) {
            return cipherData;
        }


        byte[] cipherDataByte = Hex.decode(cipherData);

        BigInteger privateKeyD = new BigInteger(privateKey, 16);
        X9ECParameters sm2Parameters = GMNamedCurves.getByName(GM_NAMED);
        ECDomainParameters domainParameters = new ECDomainParameters(sm2Parameters.getCurve(), sm2Parameters.getG(), sm2Parameters.getN());

        ECPrivateKeyParameters privateKeyParameters = new ECPrivateKeyParameters(privateKeyD, domainParameters);

        //用私钥解密
        SM2Engine sm2Engine = new SM2Engine();
        sm2Engine.init(false, privateKeyParameters);

        //processBlock得到Base64格式，记得解码
        byte[] arrayOfBytes;
        try {
            byte[] dd = sm2Engine.processBlock(cipherDataByte, 0, cipherDataByte.length);
            arrayOfBytes = Base64.getDecoder().decode(dd);
            //得到明文
            return new String(arrayOfBytes, Charset.forName(String.valueOf(StandardCharsets.UTF_8)));
        } catch (InvalidCipherTextException e) {
            logger.error("SM2解密失败：", e);
        }
        return null;
    }

    /**
     * @Description 加密(默认公钥)
     * @Author admin
     * @Date 2023/5/15 9:13
     */
    public static String encode(String plaintext) {
        return encode(plaintext, PUBLIC_KEY);
    }

    public static void main(String[] args) {
        String encryptStr ="encrypt_begin04077305df30c9ae88d57fee667fdad837eb21ee834d6afe9246d7ea58df4326966e1513ba5f5eb01562fe90a3d1222c08a7395e5ff5b07f59f811b875878e616b3755eef712da6c8259b5e58ed33c06bac5806c70b844db34737b08ee026b6920c939ccd322860124encrypt_end";
        encryptStr = encryptStr.replace("encrypt_begin","").replace("encrypt_end","");
        System.out.println(decode(encryptStr,PRIVATE_KEY_OLD));

        System.out.println(encode("1934447918794715138"));
        System.out.println(encode("2"));
    }

    /**
     * 加密
     *
     * @param plaintext
     * @param publicKey
     * @return
     */
    public static String encode(String plaintext, String publicKey) {
        if (StringUtils.isBlank(publicKey)) {
            logger.error("SM2加密失败：", "公钥为空");
        }
        // 获取一条SM2曲线参数
        X9ECParameters sm2Parameters = GMNamedCurves.getByName(GM_NAMED);
        // 构造ECC算法参数，曲线方程、椭圆曲线G点、大整数N
        ECDomainParameters domainParameters = new ECDomainParameters(sm2Parameters.getCurve(), sm2Parameters.getG(), sm2Parameters.getN());
        //提取公钥点
        ECPoint pukPoint = sm2Parameters.getCurve().decodePoint(Hex.decode(publicKey));
        // 公钥前面的02或者03表示是压缩公钥，04表示未压缩公钥, 04的时候，可以去掉前面的04
        ECPublicKeyParameters publicKeyParameters = new ECPublicKeyParameters(pukPoint, domainParameters);

        SM2Engine sm2Engine = new SM2Engine();
        // 设置sm2为加密模式
        sm2Engine.init(true, new ParametersWithRandom(publicKeyParameters, new SecureRandom()));

        byte[] arrayOfBytes = null;
        try {
            byte[] in = Base64.getEncoder().encode(plaintext.getBytes(StandardCharsets.UTF_8));
            arrayOfBytes = sm2Engine.processBlock(in, 0, in.length);
            return Hex.toHexString(arrayOfBytes);
        } catch (Exception e) {
            logger.error("SM2加密失败：", e);
        }
        return null;
    }

}
