package cn.gtmap.hlw.core.util.encryption;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @version 1.0, 2023/11/14
 * @description MD5加密工具类
 */
public class Md5Util {
    private static final char[] HEX_DIGITS = {'0', '1', '2', '3', '4', '5',
            '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private static final String ENCODING_ALGORITHM = "MD5";

    private static String characterEncoding;

    public static String encode(final String encyptContent) {
        if (encyptContent == null) {
            return null;
        }

        try {
            MessageDigest messageDigest = MessageDigest
                    .getInstance(ENCODING_ALGORITHM);

            messageDigest.update(encyptContent.getBytes());

            final byte[] digest = messageDigest.digest();

            return getFormattedText(digest);
        } catch (final NoSuchAlgorithmException e) {
            throw new SecurityException(e);
        }
    }

    public static String encode(byte[] bytes) {
        try {
            MessageDigest messageDigest = MessageDigest
                    .getInstance(ENCODING_ALGORITHM);
            messageDigest.update(bytes);
            final byte[] digest = messageDigest.digest();
            return getFormattedText(digest);
        } catch (final NoSuchAlgorithmException e) {
            throw new SecurityException(e);
        }
    }

    private static String getFormattedText(byte[] bytes) {
        final StringBuilder buf = new StringBuilder(bytes.length * 2);

        for (int j = 0; j < bytes.length; j++) {
            buf.append(HEX_DIGITS[(bytes[j] >> 4) & 0x0f]);
            buf.append(HEX_DIGITS[bytes[j] & 0x0f]);
        }
        return buf.toString();
    }
}

