package cn.gtmap.hlw.core.util.encryption;

import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.Padding;
import cn.hutool.crypto.SmUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.symmetric.SM4;

/**
 * @Author jianglin
 * @Date 2025/5/12
 * @Description
 */
public class CryptoUtils {
    /**
     * 国密sm2解密 非压缩密文
     *
     * @param text       内容
     * @param privateKey 私钥
     * @return 结果 明文
     */
    public static String sm2Decrypt(String text, String privateKey) {
        return StrUtil.utf8Str(SmUtil.sm2(privateKey, null).decryptFromBcd(text, KeyType.PrivateKey));
    }


    /**
     * 国密sm4加密
     *
     * @param text 内容
     * @param key  密钥
     * @return 结果 返回十六进制密文
     */
    public static String sm4Encrypt(String text, String key) {

        return sm4Encrypt(text, key, "", "ECB", Padding.PKCS5Padding.name());
    }

    /**
     *  国密sm4加密,支持自定义参数
     * @param text
     * @param key
     * @param iv
     * @param mode
     * @param padding
     * @return 返回十六进制密文
     */
    public static String sm4Encrypt(String text, String key, String iv, String mode, String padding) {
        return new SM4(mode, padding,
                getKey(key),
                iv.getBytes(CharsetUtil.CHARSET_UTF_8))
                .encryptHex(text);
    }


    /**
     *   国密sm4加密 支持自定义参数
     * @param text 内容
     * @param key 密钥
     * @param iv 偏移量
     * @param mode 模式("ECB","CBC")
     * @param padding  填充模式
     * @return 返回Base64密文
     */
    public static String sm4EncryptBase64(String text, String key, String iv, String mode, String padding) {
        return new SM4(mode, padding,
                getKey(key),
                iv.getBytes(CharsetUtil.CHARSET_UTF_8))
                .encryptBase64(text);
    }


    /**
     * 密钥转byte数组
     * @param key
     * @return
     */
    private static byte[] getKey(String key) {
        if (key.length() == 32) {
            return HexUtil.decodeHex(key);
        }
        if (key.length() == 16) {
            return key.getBytes();
        }
        return null;
    }

    /**
     * 国密sm4解密
     *
     * @param text 内容
     * @param key  密钥
     * @return 结果 返回明文
     */
    public static String sm4Decrypt(String text, String key) {
        return sm4Decrypt(text,key,"", "ECB", Padding.PKCS5Padding.name());
    }


    /**
     *
     * @param text 内容
     * @param key 密钥
     * @param iv 偏移量
     * @param mode 模式("ECB","CBC")
     * @param padding  填充模式
     * @return 返回明文
     */
    public static String sm4Decrypt(String text, String key,String iv, String mode, String padding) {
        return   new SM4(mode, padding,
                getKey(key),
                iv.getBytes(CharsetUtil.CHARSET_UTF_8))
                .decryptStr(text);
    }



    /**
     * 字节数组转十六进制
     * @param bytes
     * @return
     */
    private static String byte2Hex(byte[] bytes) {
        StringBuilder stringBuilder = new StringBuilder();
        String temp;
        for (byte aByte : bytes) {
            temp = Integer.toHexString(aByte & 0xFF);
            if (temp.length() == 1) {
                //1得到一位的进行补0操作
                stringBuilder.append("0");
            }
            stringBuilder.append(temp);
        }
        return stringBuilder.toString();
    }

    public static void main(String[] args) {

    }
}
