package cn.gtmap.hlw.core.util.encryption;

import cn.gtmap.hlw.core.base.ApiEncryptBody;
import cn.gtmap.hlw.core.util.encryption.sm2.Sm2lib;
import cn.gtmap.hlw.core.util.encryption.sm4.Sm4Util;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;

/**
 * @Author jianglin
 * @Date 2024/6/27
 * @Description 接口出入参-加解密-工具类
 */
@Slf4j
public class ApiSecurityUtils {

    /**
     * @param sm4KeyBySm2 经过Sm2加密的sm4key
     * @param decryptStr  经过sm4加密的数据
     * @return 解密后的数据
     */
    public static String decrypt(String sm4KeyBySm2, String decryptStr) {
        String sm4Key = Sm2lib.decode(sm4KeyBySm2);
        return Sm4Util.decryptEcb(sm4Key, decryptStr);
    }

    /**
     * @param encryptStr     要加密的数据
     * @param frontPublicKey 前端公钥
     * @return 加密后的数据
     */
    public static ApiEncryptBody encrypt(String encryptStr, String frontPublicKey)  {
        //生成一个随机的sm4加密key
        String sm4Key = null;
        try {
            sm4Key = Sm4Util.generateKey();
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        //加密
        String data = Sm4Util.encryptEcbByHutool(sm4Key, encryptStr);
        ApiEncryptBody apiEncryptRes = new ApiEncryptBody();
        //用前端公钥(用前端的公钥)，sm2加密sm4Key
        apiEncryptRes.setParamid(Sm2lib.encode(sm4Key, frontPublicKey));
        apiEncryptRes.setData(data);
        apiEncryptRes.setFrontKey(frontPublicKey);
        return apiEncryptRes;
    }

    //加解密测试
    public static void main(String[] args) throws Exception {
        String pubKey = "c2f1831616943efe504bde6b45d59eea953f04d31ecebd4c59dffd6733c7a066c7a9c14cb2c54564187891f72753fea7f56d07b19d52e9076263564def41b8e7";

        //前端入参 解密
        String dataEncrypt = "08bda6fe4ff6e25e69af67275315a44adc0b5762a891b42dea4c82d6c0627fe8244399416a0a67f5ca0613a0da76bb25a883cb23325fcc704597ada6f904c0594dfc93dc4a0cb830ad5956c395812acbb28f44855f6df6ebe06957198a47f195f42bf404067509fdd9139125673942119150cce3558e06ddd00ab70eb8a2a23acc74b11b66209e859c5a673c73ccafe4";
        String paramid = "04e815fb354060fcf785670947ddd4753270da3aa9aa18bf3dbd261f238870d589d9fa4819a687e8ac0b11b560272a34aa3a6cc0bd3c28d0a42113ecebf69701ba26cd125782d5325d89c83b8c2a86a61dc531878f45a2560b0b29d8c040c052804e1277a2bab7df2887f747c0bb4f99c4c17f810a0e5ddfb0ef97e01c86578ae85aaf3e1a9b31e7c949c7f1af";
        String qdData = ApiSecurityUtils.decrypt(paramid, dataEncrypt);
        System.out.println(qdData);

        //生成前端加密密文
        //生成一个随机的sm4加密key
        String sm4Key = "B13356B451572BFC3478AC20F0E3E163";
        //前端入参
        String encryptStr = "{\"slbh\":\"W202503190079\",\"processId\":\"b912481754e64dfea519b07745f68dc7\",\"anid\":\"\"}";
        //加密
        String data = Sm4Util.encryptEcbByHutool(sm4Key, encryptStr);
        String paramid2 = Sm2lib.encode(sm4Key);

        ApiEncryptBody body = new ApiEncryptBody();
        body.setData(data);
        body.setParamid(paramid2);
        body.setFrontKey(pubKey);

        System.out.println(JSON.toJSONString(body));
    }

}
