package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.WctJyDjxx;

import java.util.List;
import java.util.Map;

/**
 * (WctJyDjxx)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-01 11:39:31
 */
public interface WctJyDjxxRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    WctJyDjxx get(String id);

    /**
     * 新增数据
     *
     * @param wctJyDjxx 实例对象
     * @return 影响行数
     */
    void save(WctJyDjxx wctJyDjxx);

    /**
     * 修改数据
     *
     * @param wctJyDjxx 实例对象
     * @return 影响行数
     */
    void update(WctJyDjxx wctJyDjxx);

    /**
     * 批量新增数据
     *
     * @param djxxList 实例对象
     * @return 影响行数
     */
    void saveBatch(List<WctJyDjxx> djxxList);

    /**
     * 根据map查询
     *
     * @param map 实例对象
     * @return List<WctJySqrxx>
     */
    List<WctJyDjxx> getListByMap(Map<String, Object> map);

    /**
     * 根据sfssxxid查询数据
     *
     * @param sfssxxid 实例对象
     * @return
     */
    List<WctJyDjxx> listBySfssxxid(String sfssxxid);

    /**
     * 根据受理编号查询登记费信息
     *
     * @param slbh 受理编号
     * @return WctJyDjxx集合
     * @version 2.0, 2023/10/7 20:06
     * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
     */
    List<WctJyDjxx> getBySlbh(String slbh);

    /**
     * 根据sfssxxid集合查询数据
     *
     * @param sfssxxidList 实例对象
     * @return
     */
    List<WctJyDjxx> getListBySfssxxids(List<String> sfssxxidList);

    /**
     * 根据申请id查询登记费信息
     *
     * @param sqid
     * @return:List<WctJyDjxx>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<WctJyDjxx> getBySqid(String sqid);

    /**
     * 根据sfxxid删除
     *
     * @param sfxxid
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void delete(String sfxxid);

    /**
     * 根据sfssxxid删除
     * @param sfssxxid
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void deleteBySfssxxid(String sfssxxid);
    /**
     * 根据slbh查询
     *
     * @param slbhList
     * @param qlrlb
     * @return:java.util.List<cn.gtmap.hlw.domain.wct.model.WctJyDjxx>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<WctJyDjxx> listBySlbhList(List<String> slbhList, String qlrlb);
    /**
     * 根据sfssxxid和qlrlb查询
     * @param sfssxxid
     * @param qlrlb
     * @return:cn.gtmap.hlw.core.model.WctJyDjxx
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    WctJyDjxx getBySfssxxidAndQlrlb(String sfssxxid, String qlrlb);
}

