package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.HlwPzPzx;

import java.util.List;

/**
 * 配置项表(HlwPzPzx)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-08 16:06:48
 */
public interface HlwPzPzxRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param pzxid 主键
     * @return 实例对象
     */
    HlwPzPzx get(String pzxid);

    /**
     * 通过ID查询单条数据
     *
     * @param pzxKey
     * @return 实例对象
     */
    HlwPzPzx getHlwPzPzxByPzxKey(String pzxKey);

    /**
     * 通过ID查询单条数据
     *
     * @param pzxKey
     * @return 实例对象
     */
    String getHlwPzPzxValueByPzxKey(String pzxKey);

    /**
     * 通过ID查询单条数据
     *
     * @param pzxKey
     * @param defaultValue 默认值
     * @return 实例对象
     */
    String getHlwPzPzxValueByPzxKey(String pzxKey, String defaultValue);

    /**
     * 新增数据
     *
     * @param hlwPzPzx 实例对象
     * @return 影响行数
     */
    void save(HlwPzPzx hlwPzPzx);

    /**
     * 修改数据
     *
     * @param hlwPzPzx 实例对象
     * @return 影响行数
     */
    void update(HlwPzPzx hlwPzPzx);

    /**
     * 查询PC端配置
     * @param pzPzx
     * @return
     */
    List<HlwPzPzx> pcConfig(HlwPzPzx pzPzx,List<String> pzxKeyList);

    /**
     * 加载所有配置项
     * @return
     */
    List<HlwPzPzx> getHlwPzPzxAll();

    /**
     * 根据key值和区域代码查询
     * @param pzxKey
     * @param qydm
     * @return:String
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    String getHlwPzPzxValueByPzxKeyAndQydm(String pzxKey, String qydm);

    Boolean checkHlwPzByPzxKeyAndValue(String pzxKey, String checkValue);
}

