package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYyXtTssz;
import cn.gtmap.hlw.core.model.query.GxYyXtTsszQuery;

import java.util.List;

/**
 * 系统推送设置字典表(GxYyXtTssz)表数据库访问层
 *
 * @author makejava
 * @since 2023-09-12 20:48:54
 */
public interface GxYyXtTsszRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    GxYyXtTssz get(String id);

    /**
     * 新增数据
     *
     * @param gxYyXtTssz 实例对象
     * @return 影响行数
     */
    void save(GxYyXtTssz gxYyXtTssz);

    /**
     * 修改数据
     *
     * @param gxYyXtTssz 实例对象
     * @return 影响行数
     */
    void update(GxYyXtTssz gxYyXtTssz);

    /**
     * 根据申请类型、区域代码查询
     *
     * @param sqlx
     * @param qydm
     * @return 影响行数
     */
    GxYyXtTssz getBySqlxAndQydm(String sqlx, String qydm);
    /**
     * 获取推送设置
     * @param tsszQuery
     * @return:GxYyXtTssz
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    GxYyXtTssz getTssz(GxYyXtTsszQuery tsszQuery);
    /**
     * 更新申请类型查询
     * @param sqlxList
     * @return:java.util.List<cn.gtmap.hlw.core.model.GxYyXtTssz>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYyXtTssz> listBySqlxList(List<String> sqlxList);
}

