package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYySqlxJdxxLysjRel;
import cn.gtmap.hlw.core.model.JdxxLysjModel;

import java.util.List;

/**
 * 申请类型节点与领域事件关系表(GxYySqlxJdxxLysjRel)表数据库访问层
 *
 * @author makejava
 * @since 2023-08-08 09:55:46
 */
public interface GxYySqlxJdxxLysjRelRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param plid 主键
     * @return 实例对象
     */
    GxYySqlxJdxxLysjRel get(String plid);

    /**
     * 新增数据
     *
     * @param gxYySqlxJdxxLysjRel 实例对象
     * @return 影响行数
     */
    void save(GxYySqlxJdxxLysjRel gxYySqlxJdxxLysjRel);

    /**
     * 修改数据
     *
     * @param gxYySqlxJdxxLysjRel 实例对象
     * @return 影响行数
     */
    void update(GxYySqlxJdxxLysjRel gxYySqlxJdxxLysjRel);

    /**
     * 根据申请类型和节点代码获取领域事件
     *
     * @param jddm
     * @param sqlx
     * @return
     */
    List<JdxxLysjModel> queryLysjAndLydz(String jddm, String sqlx);

    /**
     * 根据申请类型和节点代码获取领域事件
     *
     * @param jddm
     * @param sqlx
     * @param lysjdm
     * @return
     */
    JdxxLysjModel queryLysjAndLydz(String jddm, String sqlx, String lysjdm);

    /**
     * 根据申请类型和节点代码获取领域事件
     *
     * @param jddm
     * @param sqlx
     * @param lysjdm
     * @param anid
     * @return
     */
    JdxxLysjModel queryLysjAndLydz(String jddm, String sqlx, String lysjdm, String anid);

    /**
     * 根据申请类型和节点代码获取领域事件
     *
     * @param jddmList
     * @param sqlx
     * @return
     */
    List<JdxxLysjModel> queryLysjAndLydz(List<String> jddmList, String sqlx);

    /**
     * 查询领域事件关系表
     *
     * @param jddm
     * @param sqlx
     * @param lysjdm
     * @return:GxYySqlxJdxxLysjRel
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    GxYySqlxJdxxLysjRel get(String jddm, String sqlx, String lysjdm);
}

