package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYyQlr;

import java.util.List;

/**
 * 不动产权利人表(GxYyQlr)表数据库访问层
 *
 * @author makejava
 * @since 2023-05-31 14:14:45
 */
public interface GxYyQlrRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param qlrid 主键
     * @return 实例对象
     */
    GxYyQlr get(String qlrid);

    /**
     * 通过证件号查询数据
     *
     * @param sqid   申请id
     * @param qlrzjh 权利人证件号
     * @return 实例对象
     */
    List<GxYyQlr> getBySqidAndQlrzjh(String sqid, String qlrzjh);

    /**
     * 通过受理编号和证件号查询数据
     *
     * @param slbh   受理编号
     * @param qlrzjh 权利人证件号
     * @return 实例对象
     */
    List<GxYyQlr> getBySlbhAndQlrzjh(String slbh, String qlrzjh);

    /**
     * 通过sqid查询集合数据
     *
     * @param sqid
     * @return 实例对象
     */
    List<GxYyQlr> list(String sqid);

    /**
     * 新增数据
     *
     * @param gxYyQlr 实例对象
     * @return 影响行数
     */
    void save(GxYyQlr gxYyQlr);

    /**
     * 修改数据
     *
     * @param gxYyQlr 实例对象
     * @return 影响行数
     */
    void update(GxYyQlr gxYyQlr);

    /**
     * 保存或修改数据
     *
     * @param gxYyQlr 实例对象
     * @return
     */
    void saveOrUpdate(GxYyQlr gxYyQlr);

    /**
     * 批量保存或修改数据
     *
     * @param gxYyQlrList 实例对象
     * @return
     */
    void saveOrUpdateBatch(List<GxYyQlr> gxYyQlrList);

    /**
     * 根据sqid删除
     *
     * @param sqid
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void deleteBySqid(String sqid);

    /**
     * 根据sqid查询
     *
     * @param sqid
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYyQlr> selectQlrBySqid(String sqid);

    /**
     * 根据qlrid删除
     *
     * @param qlrid
     * @return:void
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     */
    int delete(String qlrid);

    /**
     * 根据sqidList和权利人类型
     *
     * @param sqidList
     * @param qlrlx
     * @return:void
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     */
    int deleteBySqidListAndQlrlx(List<String> sqidList, String qlrlx);

    /**
     * 根据sqidList和权利人类型删除
     *
     * @param sqid
     * @param qlrlx
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    int deleteBySqidAndQlrlx(String sqid, String qlrlx);


    /**
     * 根据sqid,qlrzjh查询
     *
     * @param sqid
     * @param qlrzjh
     * @param qlrlx
     * @return:void
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     */
    List<GxYyQlr> get(String sqid, String qlrzjh, String qlrlx);

    /**
     * 根据sqid,qlrlx
     *
     * @param sqid
     * @param qlrlx
     * @return:void
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     */
    List<GxYyQlr> getBySqidAndQlrlx(String sqid, String qlrlx);

    /**
     * 通过sqidList查询集合数据
     *
     * @param sqidList 主键
     * @return 实例对象
     */
    List<GxYyQlr> list(List<String> sqidList);

    /**
     * 通过sqidList查询集合数据
     *
     * @param sqidList 主键
     * @param qlrlx    权利人类型
     * @return 实例对象
     */
    List<GxYyQlr> getBySqidListAndQlrlx(List<String> sqidList, String qlrlx);

    /**
     * 通过slbh查询集合数据
     *
     * @param slbh
     * @return 实例对象
     */
    List<GxYyQlr> getBySlbh(String slbh);

    /**
     * 通过slbh，qlrlx查询集合数据
     *
     * @param slbh
     * @return 实例对象
     */
    List<GxYyQlr> getBySlbhAndQlrlx(String slbh, String qlrlx);

    /**
     * 获取是否满五唯一通过受理编号
     *
     * @param slbh
     * @return 实例对象
     */
    Boolean getSfmwwyBySlbh(String slbh);

    /**
     * 根据sqid集合删除
     *
     * @param sqidList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void deleteBySqidList(List<String> sqidList);

    /**
     * 根据qlrid集合删除
     *
     * @param qlridList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void deleteByQlridList(List<String> qlridList);

    /**
     * 批量保存
     *
     * @param gxYyQlrList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void saveBatch(List<GxYyQlr> gxYyQlrList);

    /**
     * 根据sqid和权利人证件号删除
     *
     * @param sqid
     * @param qlrzjhList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void deleteBySqidAndQlrzjhList(String sqid, List<String> qlrzjhList);

    /**
     * @param
     * @return
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     * @description 根据申请id查询并根据qlrid字段排序
     */
    List<GxYyQlr> listOrderByQlrzjh(String sqid);

    /**
     * @param
     * @return
     * @author <a href="mailto:chenjia@gtmap.cn">chenjia</a>
     * @description 根据申请id查询并根据字段排序
     */
    List<GxYyQlr> listOrderAsc(String sqid, String order);
}

