package cn.gtmap.hlw.core.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 登记中心与字典关系表(GxYyDjzxZdRel)表实体类
 *
 * @author makejava
 * @since 2024-02-23 10:26:37
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GxYyDjzxZdRel implements Serializable {

    private static final long serialVersionUID = -6919142232349627112L;

    /**
     * 表id
     */
    private String id;

    /**
     * 登记中心代码（gx_yy_djzx.djzxdm）
     */
    private String djzxdm;

    /**
     * 字典类型（gx_yy_zd_type.zd_type）
     */
    private String zdType;

    /**
     * 字典代码（gx_yy_zd_type.dm）
     */
    private String zdDm;

    /**
     * 子字典类型，主要为了二级联动（gx_yy_zd_type.zd_type）
     */
    private String fZdType;

    /**
     * 子字典代码，主要为了二级联动（gx_yy_zd_type.dm）
     */
    private String fZdDm;
}

