package cn.gtmap.hlw.core.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;


/**
 * (GxYyAhfwtc)表实体类BO
 *
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @since 2023-09-04 10:57
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GxYyAhfwtc implements Serializable {

    private static final long serialVersionUID = -582890040798359769L;
    private String id;

    /**
     * 受理编号
     */
    private String slbh;

    /**
     * 产权证号
     */
    private String cqzh;

    /**
     * 坐落
     */
    private String zl;

    /**
     * 权利人名称
     */
    private String qlrmc;

    /**
     * 权利人证件号
     */
    private String qlrzjh;

    /**
     * 权利人类型
     */
    private String qlrlx;

    /**
     * 房屋用途代码
     */
    private String fwytdm;

    /**
     * 房屋用途名称
     */
    private String fwytmc;

    /**
     * 是否计算房屋套次（0-否 1-是）
     */
    private String sfjsfwtc;
    /**
     * 计算方式 0：系统自动纳入计算，1：用户手动纳入计算  （0：用户不可取消，必须作为房屋套次计算数据）
     */
    private String  jsfs;

    /**
     * 权利人ID(gx_yy_qlr.qlrid)
     */
    private String qlrid;
}

