package cn.gtmap.hlw.core.enums.sqxx;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2024/11/30
 * @description 授权结果
 */
@Getter
@AllArgsConstructor
public enum SqjgEnum {
    /**
     * 授权结果- 待授权
     */
    SQJG_DSQ(0, "待授权"),

    /**
     * 授权结果- 已授权
     */
    SQJG_YSQ(1, "已授权"),
    /**
     * 授权结果- 拒绝授权
     */
    SQJG_JJSQ(2, "拒绝授权"),
    /**
     * 授权结果- 授权已过期
     */
    SQJG_YGQ(3, "授权已过期"),
    /**
     * 授权结果- 授权请求作废
     */
    SQJG_ZF(4, "授权请求作废");

    private Integer code;

    private String msg;
}
