package cn.gtmap.hlw.core.enums.menu;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/11/13 17:58
 * @description TypeEnum
 */
@Getter
@AllArgsConstructor
public enum ProcessTypeEnum {
    /**
     * 流程申请
     */
    PROCESS_TYPE_LCSQ("0", "流程申请"),
    /**
     * 流程核验
     */
    PROCESS_TYPE_LCHY("1", "流程核验"),
    /**
     * 流程查看
     */
    PROCESS_TYPE_LCCK("2", "流程查看"),
    /**
     * 退回修改
     */
    PROCESS_TYPE_THXG("3", "退回修改"),
    /**
     * 流程一审
     */
    PROCESS_TYPE_LCYS("4", "流程一审"),
    /**
     * 流程二审
     */
    PROCESS_TYPE_LCES("5", "流程二审"),
    /**
     * 税费缴纳
     */
    PROCESS_TYPE_SFJN("6", "税费缴纳");


    private String code;

    private String msg;

    /**
     * 获取名称
     * @param code
     * @return
     */
    public static String getMsg(String code) {
        for (ProcessTypeEnum xq : ProcessTypeEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getMsg();
            }
        }
        return null;
    }
}
