package cn.gtmap.hlw.core.enums.menu;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 微信端
 *
 * @author admin
 * @Date 2023-06-25
 * @Version V1.0
 */
@Getter
@AllArgsConstructor
public enum ClientTypeEnum {
    /**
     * 微信端
     */
    CLIENT_TYPE_WX("1", "微信端"),
    /**
     * 微信端
     */
    CLIENT_TYPE_WEB("2", "WEB端"),
    /**
     * 云受理端
     */
    CLIENT_TYPE_YSL("5", "云受理端");

    /**
     * APP端
     *//*
    CLIENT_TYPE_APP("3", "APP端"),

    *//**
     * 其它
     *//*
    CLIENT_TYPE_QT("4", "其它");*/

    private String code;

    private String msg;

    public static String getMsg(String code) {
        for (ClientTypeEnum xq : ClientTypeEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getMsg();
            }
        }
        return null;
    }
}

