package cn.gtmap.hlw.core.dto.sw.hs.kunsan;

import cn.gtmap.hlw.core.annotation.ZdDzConfig;
import cn.gtmap.hlw.core.constant.dict.ZdDzConstant;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/9/19
 * @description
 */
@Data
public class HouseVO {
    /**
     * 交易编号
     */
    private String jybh;
    /**
     * 评估交易日期
     */
    private String pgjyrq;
    /**
     * 合同编号
     */
    private String htbh;
    /**
     * 地市代码
     */
    private String xzqhds;
    /**
     * 县区代码
     */
    private String xzqhxq;
    /**
     * 街道
     */
    private String xzqhjd;
    /**
     * 小区名称
     */
    private String xq;
    /**
     * 小区代码
     */
    @JSONField(name = "xq_dm")
    private String xqDm;
    /**
     * 房屋坐落地址
     */
    private String fwzldz;
    /**
     * 道路名称
     */
    private String dlmc;
    /**
     * 门牌号码
     */
    private String mphm;
    /**
     * 栋号
     */
    private String dh;
    /**
     * 总楼层
     */
    private String fwlcs;
    /**
     * 所在层
     */
    private String szc;
    /**
     * 房号
     */
    private String fh;
    /**
     * 房屋性质小类
     */
    private String fwxzxl;
    /**
     * 房屋类型
     */
    @ZdDzConfig(field = "fwlx", tableName = ZdDzConstant.ZD_DZ_FWLX, dmToDm = true)
    private String fwlx;
    /**
     * 用途
     */
    private String yt;
    /**
     * 房屋结构
     */
    @ZdDzConfig(field = "fwjg", tableName = ZdDzConstant.ZD_DZ_FWJG, dmToDm = true)
    private String fwjg;
    /**
     * 东西至
     */
    private String dxz;
    /**
     * 房屋建成年份
     */
    private String fwjcsj;
    /**
     * 土地房屋面积
     */
    private String tdfwmj;
    /**
     * 车库面积
     */
    private String ckmj;
    /**
     * 阁楼面积
     */
    private String glmj;
    /**
     * 储藏室面积
     */
    private String ccsmj;
    /**
     * 总面积
     */
    private String zmj;
    /**
     * 商铺面积一层
     */
    private String spmjyc;
    /**
     * 商铺面积二层
     */
    private String spmjec;
    /**
     * 商铺面积三层
     */
    private String spmjsc;
    /**
     * 商铺面积四层及四层以上
     */
    private String spmjsicys;
    /**
     * 商铺面积地下室或半地下室
     */
    private String spmjdxshbdxs;
    /**
     * 钢结构厂房、仓库
     */
    private String gjgcfck;
    /**
     * 钢砼厂房、仓库
     */
    private String gtcfck;
    /**
     * 砖混结构厂房、仓库
     */
    private String zhjgck;
    /**
     * 成交价格
     */
    private String cjjg;
    /**
     * 权属转移份额
     */
    private String qszyfe;
    /**
     * 产权人姓名
     */
    private String cqrmc;
    /**
     * 产权人证件号码
     */
    private String zjhm;
    /**
     * 终端类型
     */
    private String zdlx;
    /**
     * 型号
     */
    private String zdxh;
    /**
     * 调用人证件类型
     */
    private String dyrzjlx;
    /**
     * 调用人证件号码
     */
    private String dyrzjhm;
    /**
     * 调用人类型
     */
    private String dyrlx;
    /**
     * 所属税务机关代码
     */
    private String swjgdm;
}
