package cn.gtmap.hlw.core.dto.sqxx.push.dj3.dyzy;


import cn.gtmap.hlw.core.annotation.ZdDzConfig;
import cn.gtmap.hlw.core.constant.dict.ZdDzConstant;
import lombok.Data;

import java.util.List;

/**
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @version 2024/4/8 13:36
 * @description 登记3.0 转移抵押合并流程创建入参
 */
@Data
public class PushDj3DyZyDyxxParamsBO {

    /**
     * 被担保主债权数额（最高债权数额）
     */
    private String bdbzzqse;
    /**
     * 抵押方式
     */
    private String dyfs;
    /**
     * 债务履行开始期限
     */
    private String zwlxksqx;
    /**
     * 债务履行结束期限
     */
    private String zwlxjsqx;
    /**
     * 登记小类申请类型
     */
    private String xlsqdjlx;
    /**
     * 项目id
     */
    private String xmid;
    /**
     * 抵押证明号
     */
    private String bdcqzh;
    /**
     * 抵押用途
     */
    private String djyy;
    /**
     * 抵押顺位
     */
    private String dysw;
    /**
     * 备注
     */
    private String bz;
    /**
     * 评估价值
     */
    private String pgjz;
    /**
     * 权利顺序
     */
    private String qlsx;
    /**
     * 登记原因代码
     */
    private String djyydm;
    /**
     * 登记原因名称
     */
    private String djyymc;
    /**
     * 债务人
     */
    private String zwr;
    /**
     * 不动产价值（抵押物价值）
     */
    private String bdcjz;
    /**
     * 贷款方式
     */
    private String dkfs;
    /**
     * 贷款方式名称
     */
    private String dkfsmc;
    /**
     * 最高债权确定事实
     */
    private String zgzqqdss;
    /**
     * 抵押面积（房屋面积）
     */
    private String dymj;
    /**
     * 抵押面积其中土地（土地面积）
     */
    private String dymjqztd;
    /**
     * 被担保债权数额其中土地
     */
    private String bdbzzqseqztd;
    /**
     * 抵押物价值其中土地
     */
    private String dywjzqztd;
    /**
     * 是否涉税
     */
    private String sfss;

    /**
     * 债权人信息列表
     */
    @ZdDzConfig(field = "qlrxx", tableName = "", isList = true)
    private List<PushDj3DyZyQlrxxParamsBO> qlrxx;

    /**
     * 债务人信息列表
     */
    private List<PushDj3DyZyZwrxxParamsBO> zwrxx;

    /**
     * 收费信息列表
     */
    private List<PushDj3DyZySfxxParamsBO> sfxx;

    /**
     * 网络信息列表
     */
    private List<PushDj3DyZyWlxxParamsBO> wlxx;

    /**
     * 担保范围
     */
    private String dbfw;
    /**
     * 顺序
     */
    private String sx;
    /**
     * 附记
     */
    private String fj;

    /**
     * 是否禁止抵押期间抵押物转让
     * 放代码，1：禁止，0：同意
     */
    private String sfjzdyqjdywzr;
    /**
     * 最高债权额（单位：万元）
     */
    private String zgzqe;
    /**
     * 登记事由代码
     */
    private String djsydm;

    /**
     * 抵押金额类型
     */
    @ZdDzConfig(field = "dyjelxdm", tableName = ZdDzConstant.ZD_DZ_DYJELX, dmToDm = true)
    private String dyjelxdm;

    /**
     * 抵押金额类型名称
     */
    @ZdDzConfig(field = "dyjelxdm", tableName = ZdDzConstant.ZD_DZ_DYJELX, dmToMc = true)
    private String dyjelxmc;

    /**
     * 是否无还本续贷款
     */
    private String sfwhbxd;

    /**
     * 原抵押金额
     */
    private String ydyje;

    private String htbh;
}
