package cn.gtmap.hlw.core.dto.news;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/7/3 10:27
 * @description CustomNewsResultDTO
 */
@Data
public class CustomNewsResultDTO {
    /**主键 */
    private String id;

    /**标题 */
    private String title;

    /**作者*/
    private String author;

    /**HTML路径地址*/
    private String url;

    /**创建时间*/
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createDate;

    /**所属类型（0:所有，1：微信，2：web）*/
    private String type;

    /**HTML文本*/
    private String content;
    /**app端文本*/
    private String h5content;

    /**新闻类型关联字典表*/
    private String newsType;
    /**新闻类型关联字典表名称*/
    private String newsTypeName;

    /**来源*/
    private String origin;

    /**登记中心编码关联gx_yy_djzx的djzxdm字段*/
    private String djzxdm;

    /**更新时间*/
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateDate;

    /**状态（0草稿，1发布，2下架）*/
    private Integer status;

    /**置顶时间*/
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date zdsj;

    /**阅读量*/
    private Integer ydl;

    /**申请类型 （字典gx_yy_zd_sqlx）*/
    private String sqlx;

    /**登记类型（字典gx_yy_zd_type  DJLX）*/
    private String djlx;

    /**二级标题*/
    private String secondTitle;

    /**一级标题顺序号*/
    private Integer sxh;

    /**二级标题顺序号*/
    private Integer secondSxh;

    /**是否置顶*/
    private String sfzd;
    /**
     * 父级id
     */
    private String parentId;
    /**附件信息*/
    private List<FjxxZxglDTO> fjxxZxglList;

    private List<CustomNewsResultDTO> children;

}
