package cn.gtmap.hlw.core.dto.exchange.push;

import cn.hutool.core.date.DatePattern;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2025/3/25
 * @description 查封信息
 */
@Data
public class PushCfxxDTO {
    private Integer cfxxid;

    /**  受理编号（与sqxx表关联）*/
    private String slbh;

    /**查封文号*/
    private String cfwh;

    /**查封机关*/
    private String cfjg;

    /**查封申请人*/
    private String cfsqr;

    /**查封开始日期*/
    @JsonFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private Date cfksrq;

    /**查封结束日期*/
    @JsonFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private Date cfjsrq;

    /**解封机关*/
    private String jfjg;

    /**解封文号*/
    private String jfwh;

    /**查封文件*/
    private String cfwj;

    /**解封文件*/
    private String jfwj;

    /**解封日期*/
    @JsonFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private Date jfrq;

    /**续封开始日期*/
    @JsonFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private Date xfksrq;

    /**续封结束日期*/
    @JsonFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private Date xfjsrq;

    /**查封范围*/
    private String cffw;

    /**sqid,与sqxx表中sqid关联*/
    private String sqid;

    /** 附记*/
    private String fj;

    /**s法院送达人联系电话*/
    private String fysdrlxdh;

    /**续封申请人*/
    private String xfsqr;

    /**续封文号*/
    private String xfwh;

    /**续封文件*/
    private String xfwj;

    /**续封机关*/
    private String xfjg;

    /**续封范围*/
    private String xffw;

    /**s法院送达人*/
    private String fysdr;
    /**
     * 法院解封送达人
     */
    private String jfsdr;
    /**
     * 法院解封送达人联系电话
     */
    private String jfsdrlxdh;

    /**法院查封送达人*/
    private String fycfsdr;

    /**法院解封送达人*/
    private String fyjfsdr;

    /**法院解封送达人电话*/
    private String fyjfsdrlxdh;

    /**
     * 查封类型
     */
    private String cflx;
    /**
     * 查封顺序
     */
    private Integer cfsx;
    /**
     * 来文日期
     */
    private Date lwrq;
    /**
     * 解封申请人
     */
    private String jfsqr;
    /**
     * 查封期限
     */
    private String cfqx;
    /**
     * 申请执行人
     */
    private String sqzxr;
    /**
     * 查封冻结原因
     */
    private String cfdjyy;
}
