package cn.gtmap.hlw.core.dto.dsrw;

import cn.gtmap.hlw.core.base.BasePage;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 *定时任务台账响应数据
 *
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @since 2023-12-18 13:18:10
 */
@Data
public class DsrwPageResultDTO extends BasePage {

    /**
     * 任务ID
     */
    private String dsrwid;

    /**
     * 任务名称
     */
    private String rwmc;

    /**
     * 任务组名
     */
    private String rwzm;

    /**
     * 执行规则（cron定时任务表达式）
     */
    private String zxgz;

    /**
     * 任务状态（正常 暂停）
     */
    private String rwzt;

    /**
     * 任务状态（正常 暂停）
     */
    private String rwztmc;

    /**
     * 任务状态更新时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date rwztgxsj;

    /**
     * 上次执行时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date sczxsj;

    /**
     * 是否使用token, 1：使用， 0：不使用
     */
    private String sfsytoken;

    /**
     * token关键字
     */
    private String tokengjz;

    /**
     * 接口入参
     */
    private String jkrc;

    /**
     * 接口请求方式：GET,POST
     */
    private String jkqqfs;

    /**
     * 是否异步执行，0：否，1：是，默认是：0'
     */
    private String sfybzx;

    /**
     * 接口地址
     */
    private String jkdz;
}
