package cn.gtmap.hlw.core.dto.dict.sqlx;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/7/12 16:54
 * @description ZdSqlxSaveParamsDTO
 */
@Data
public class ZdSqlxSaveParamsDTO {
    /**
     * 主键
     */
    private String id;

    /**
     * 申请类型代码
     */
    private String dm;

    /**
     * 申请类型名称
     */
    private String mc;

    /**
     * 所属用户类型（角色id）
     */
    private String ssyhlx;

    /**
     * 是否删除
     */
    private Integer isDelete;

    /**
     * 登记申请类型
     */
    private String djsqlx;

    /**
     * 登记申请类型名称
     */
    private String djsqlxmc;

    /**
     * 申请类型代码所属代码【大类】
     */
    private String subDm;

    /**
     * 是否验证推送合同（0:否，1:是）
     */
    private String sfyztsht;

    /**
     * 是否抵押0:抵押1:不抵押
     */
    private String sfdy;

    /**
     * 是否抵押注销
     */
    private String sfdyzx;

    /**
     * 是否二次转移 1 是 0 否，默认否或空值
     */
    private String sfeczy;

    /**
     * 区域代码
     */
    private String qydm;

    /**
     * 是否组合（0：组合，1：非组合）
     */
    private String sfzh;

    /**
     * 等级层级(1,2,3)
     */
    private String grade;

    /**
     * 备注（视频问询我的申请备注描述）
     */
    private String mark;

    private String href;

    private String icon1;

    private String icon2;

    /**
     * 自增ID
     */
    private Integer zzid;

    /**
     * 创建时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createDate;

    /**
     * 修改时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateDate;

    /**
     * 叙述描写，我的申请叙述
     */
    private String describes;

    /**
     * 申请类型代码包含所属代码【小类】
     */
    private String containDm;

    /**
     * 权利人是否需要会签（0:否，1:是）
     */
    private String qlrsfhq;

    /**
     * 义务人是否需要会签（0:否，1:是）
     */
    private String ywrsfhq;

    /**
     * 是否抵押验证（0:否，1:是）
     */
    private String sfdyyz;

    /**
     * 是否查封验证（0:否，1:是）
     */
    private String sfcfyz;

    /**
     * 是否需要预约（0:否，1:是）
     */
    private String sfxyyy;

    /**
     * 是否通用申请（0:否，1:是）
     */
    private String sftysq;

    /**
     * 登记是否创建项目（0:否，1:是）
     */
    private String djsfcjxm;

    /**
     * 是否产权证号验证（0:否，1:是）
     */
    private String sfcqzhyz;

    /**
     * 登记是否需要创建前验证，0不需要；1需要
     */
    private String djsfcjyz;

    /**
     * 登记是否自动转发向审核节点 0不转发 1转发
     */
    private String djsfzdzf;

    /**
     * 交易合同类型(chpc:现房商品房合同 chpy:预告，期房商品房合同 shc:存量房合同)
     */
    private String jyhtlx;

    /**
     * 是否需要预审(0否，1是)
     */
    private String sfxyys;

    /**
     * 否推送交易系统(0否，1是)
     */
    private String sftsjy;

    /**
     * 会签人（0：默认权利人，1：法定代表人或负责人）
     */
    private String hqr;

    /**
     * 是否需要纳税（0否，1是）
     */
    private String sfxyns;

    /**
     * 顺序号
     */
    private String sxh;

    /**
     * 审核已通过提交材料期限
     */
    private String shtgtjclqx;

    /**
     * 是否涉税（0不涉税；1涉税）
     */
    private String sfss;

    /**
     * 核验人是否可以查看（0：否，1：是）
     */
    private String hyrsfkyck;

    private String sfxyqz;

    /**
     * 承诺期限（用于打印配置承诺期限）
     */
    private String cnqx;

    /**
     * 预约中心锁定（0:否不锁定预约中心，1:是锁定预约中心）
     */
    private String yyzxsd;

    /**
     * 预审登记申请类型（用于推送给登记预审配置的登记的djsqlx）
     */
    private String ysdjsqlx;

    /**
     * 权利人是否需要人证比对（1：需要 2：不需要）
     */
    private String qlrsfrzbd;

    /**
     * 义务人是否需要人证比对（1：需要 2：不需要）
     */
    private String ywrsfrzbd;

    /**
     * 权利人是否需要全部核验(0否；1是)
     */
    private String qlrsfxyqbhy;

    /**
     * 登记是否自动办结（1：是，0：否）
     */
    private String djsfzdbj;

    /**
     * 登记跳过节点数
     */
    private String djtgjds;

    /**
     * 权利人是否需要云签（0:是，1：否）
     */
    private String qlrsfxyyq;

    /**
     * 义务人是否需要云签（0:是，1：否）
     */
    private String ywrsfxyyq;

    /**
     * 会签方式（0：三方会签（个人核验完成后，银行进行核验）1：开发商待办（转移流程个人核验）2：银行优先会签）
     */
    private String hqfs;

    /**
     * 模型ID
     */
    private String mxid;

    /**
     * 受理来源
     * （互联网+：wwsq，一窗受理：
     * ycsl，交易系统：
     * jyxt，
     * 互联网+非银行：3，
     * 互联网+银行：6，
     * 10：南通一体化平台，
     * 11南通大市）
     */
    private String slly;

    /**
     * 是否台账下拉框显示（1：是，0否）
     */
    private String sftzxlkxs;

    /**
     * 父类型关联gx_yy_zd_type表中id，当zd_type为SQLXFLX
     */
    private String flx;

    /**
     * 申请是否需要签章（0：否，1：是）
     */
    private String sqsfxyqz;

    /**
     * 核验是否需要签章（0：否，1：是）
     */
    private String hysfxyqz;

    /**
     * 是否需要预受理（0：否，1：是）
     */
    private String sfxyysl;

    /**
     * 权利人代理人是否需要云签（0:是，1：否）
     */
    private String qlrdlrsfxyyq;

    /**
     * 义务人代理人是否需要云签（0:是，1：否）
     */
    private String ywrdlrsfxyyq;

    /**
     * 权利人监护人是否需要云签（0:是，1：否）
     */
    private String qlrjhrsfxyyq;

    /**
     * 义务人监护人是否需要云签（0:是，1：否）
     */
    private String ywrjhrsfxyyq;

    /**
     * e签宝视频认证模板id
     */
    private String facevideotemplate;

    /**
     * e签宝意愿认证方式(多种用英文逗号隔开)
     */
    private String willtypes;

    /**
     * 通用页面实现方式（1：查询房屋信息-6.1.7接口；2：查询土地信息-5.4.21接口；3：房屋首次信息-5.7.1和5.7.2接口；4：土地首次信息-5.7.35和5.7.9接口）
     */
    private String tyymsxfs;

    /**
     * 权利人缴费项目代码(多种用英文逗号隔开)
     */
    private String qlrjfxmdm;

    /**
     * 义务人缴费项目代码(多种用英文逗号隔开)
     */
    private String ywrjfxmdm;

    /**
     * 电子签名签章类型（不配置默认获取配置文件tongyong.dsf.qm.lx.gr.qy）组合流程配置大类
     */
    private String dzqmqzlx;

    /**
     * 登记特殊业务类型
     */
    private String djtsywlx;

    /**
     * 权利类型（推送缴费给3.0所需字段）
     */
    private String qllx;

    /**
     * 是否原抵押（0：否，1：是）
     */
    private String sfydy;

    /**
     * 是否市县一体化流程（0：否，1：是）
     */
    private String sfsxythlc;

    /**
     * 是否一次收费(1：是，0：否)
     */
    private String sfycjf;

    /**
     * 是否缴费（0：否，1：是）
     */
    private String sfjf;
    /**
     * 角色
     */
    private List<String> roleIdList;
    /**
     * 申请书权利类型
     */
    private List<String> sqsQllxList;
    /**
     * 登记类型
     */
    private String djlx;

    /**
     * 流程删除后是否通知交易系统（0：否，1：是）
     */
    private String lcscsftcjy;
}
