package cn.gtmap.hlw.core.domain.sign.model.create.params;

import cn.gtmap.hlw.core.base.UserInfo;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/7/8 15:24
 * @description SignFlowsCreateParamsBO
 */
@Data
public class SignFlowsCreateParamsModel {

    /**
     * 领域动作是否中断执行 是则不继续执行后续动作
     */
    private Boolean sfzd;

    /**
     * Lysjdm
     */
    private String lysjdm;

    /**
     * 步骤id  产权办件授权使用
     */
    private String processId;

    /**
     * 步按钮id
     */
    private String anid;

    /**
     * 步骤id 流程中云签使用
     */
    private String jddm;

    /**
     * 受理编号
     */
    private String slbh;

    /**
     * 批量云签受理编号
     */
    private List<String> slbhList;

    /**
     * sqid
     */
    private String sqid;

    /**
     * 需要云签的附件类型
     */
    private String signFjlx;

    /**
     * 签署人权利人类型集合，通过勾选不同的动作塞入数据，这个集合一旦有值，云签组织将不会按照流程打印表的权利人类型去组织签署人信息，而是优先通过勾选的动作组织
     */
    private List<String> signQlrlxList;

    /**
     * 需要云签的附件名称
     */
    private String signFjmc;

    /**
     * 需要云签的附件base64
     */
    private String signFjBase64;

    /**
     * 流程打印配置id
     */
    private String lcdyPzid;

    /**
     * sqid
     */
    private String qlrlx;

    /**
     * 申请类型
     */
    private String sqlx;

    /**
     * 坐落
     */
    private String zl;

    /**
     * 厂商代码
     */
    private String csdm;

    /**
     * 区域代码
     */
    private String qydm;

    /**
     * 备案状态代码
     */
    private String baztdm;

    /**
     * 是否资金监管
     */
    private String sfzjjg;
    /**
     * 是否视频办
     */
    private Boolean sfspb = false;
    /**
     * 是否跳过附件是否存在的校验
     */
    private Boolean isSkipFjIsExistsCheck = false;
    /**
     * 接口关键字
     */
    private String jkgjz;

    /**
     * 云签数据
     */
    private SignFlowsCreateDataParamsModel data;

    /**
     * 签字板数据
     */
    private List<SignFlowsCreateBoardParamsModel> signBoardList;

    /**
     * 云签文件
     */
    @JSONField(serialize = false)
    private List<MultipartFile> fileList;

    /**
     * 签署人证件号
     */
    private List<String> qsrZjhList;

    /**
     * 用户类型
     */
    private String yhlx;
    /**
     * 当前登录用户信息（存在异步执行打印的情况，session取值当前登录人会存在取不到值的问题）
     */
    private UserInfo userInfo;
}
