package cn.gtmap.hlw.core.dao.org;

import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.dto.user.org.OrgListQueryParamsDTO;
import cn.gtmap.hlw.core.model.GxYyOrgSqlx;

import java.util.List;

/**
 * (GxYyOrg)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-01 11:39:31
 */
public interface GxYyOrgSqlxDao {

    /**
     * 查询单条数据
     *
     * @return
     */
    GxYyOrgSqlx get(String uuid);

    /**
     * 查询全部
     *
     * @return 实例对象
     */
    List<GxYyOrgSqlx> getAll();

    /**
     * @param orgId
     * @return List<GxYyOrgSqlxPO>
     * @description 查询
     */
    List<GxYyOrgSqlx> getByOrgId(String orgId);

    /**
     * @param sqlx
     * @return List<GxYyOrgSqlxPO>
     * @description 查询
     */
    List<GxYyOrgSqlx> getBySqlx(String sqlx);


    /**
     * 新增或修改
     *
     * @param gxYyOrgSqlxPO
     * @return String
     */
    String saveOrUpdateOrg(GxYyOrgSqlx gxYyOrgSqlxPO);

    Boolean checkExist(String uuid, String sqlx, String orgId);

    /**
     * 接口实现 删除
     *
     * @param uuid 主键
     * @return 删除的条数
     */
    void delete(String uuid);

    /**
     * 分页查询
     *
     * @param orgListQueryParamsDTO
     * @return GxYyMenuPO集合
     */
    PageInfo<GxYyOrgSqlx> queryPage(OrgListQueryParamsDTO orgListQueryParamsDTO);
}

