package cn.gtmap.hlw.core.dao.menu;

import cn.gtmap.hlw.core.model.GxYyMenuUserRel;

import java.util.List;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2024/9/5
 * @description
 */
public interface GxYyMenuUserRelDao {
    /**
     * 根据菜单id删除
     *
     * @param functionMenuId
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void deleteByFunctionMenuId(String functionMenuId);

    /**
     * 根据菜单id查询
     *
     * @param functionMenuId
     * @return:List<GxYyMenuUserRelPO>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYyMenuUserRel> getByFunctionMenuId(String functionMenuId);

    /**
     * 根据用户id查询
     *
     * @param userId
     * @return:List<GxYyMenuUserRelPO>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYyMenuUserRel> getMenuUserRelList(String userId);

    /**
     * 根据菜单查询
     *
     * @param functionMenuIds
     * @return:List<GxYyMenuUserRelPO>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYyMenuUserRel> getByFunctionMenuIds(List<String> functionMenuIds);

    void saveBatch(List<GxYyMenuUserRel> menuUserRelList);
}
