package cn.gtmap.hlw.core.dao.djzx;

import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.dto.djzx.DjzxZdRelQueryDTO;
import cn.gtmap.hlw.core.model.GxYyDjzxZdRel;

import java.util.List;

/**
 * 登记中心与字典关系表(GxYyDjzxZdRel)表数据库访问层
 *
 * @author makejava
 * @since 2024-02-06 17:03:41
 */
public interface GxYyDjzxZdRelDao {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    GxYyDjzxZdRel get(String id);

    /**
     * 新增数据
     *
     * @param djzxZdRelList 实例对象
     * @return 影响行数
     */
    void saveOrUpdateBatch(List<GxYyDjzxZdRel> djzxZdRelList);

    /**
     * 批量删除
     *
     * @param idList
     * @return 影响行数
     */
    void deleteBatch(List<String> idList);

    /**
     * 批量删除
     *
     * @param djzxdm
     * @return 影响行数
     */
    void deleteByDjzxdm(String djzxdm);


    /**
     * 分页查询
     *
     * @param queryDTO
     * @return
     */
    PageInfo<GxYyDjzxZdRel> page(DjzxZdRelQueryDTO queryDTO);

    /**
     * 查询
     *
     * @param queryDTO
     * @return
     */
    List<GxYyDjzxZdRel> queryByDjzxdm(DjzxZdRelQueryDTO queryDTO);

}
